//								EJEMPLO 5
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Mquina de taladrado
//
//Al accionar el pulsador "I" (RA0) el cabezal realiza un descenso rpido de aproximacin,
//activando el motor de bajada rpida "BR"(RB3). Al llegar al sensor "b" (RA2), se activa 
//el rel "M" (RB1) que hace girar el motor de la broca y se realiza un descenso lento para 
//el taladrado de la pieza "BL" (RB4). Cuando se activa el sensor "c" (RA3) se considera 
//que la pieza est taladrada. Se inicia una subida rpida del cabezal "SR" (RB0) al tiempo
//que el rel "M" (RB1) de giro sigue activado. Cuando se alcanza el final de carrera "a" 
//(RA1), se detiene la subida rpida "SR"(RB0), el rel de giro "M" (RB1) y se activa una 
//seal acstica "A" (RA2) de aviso. El ciclo comienza con una nueva pulsacin de "I" (RA0).
	

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

main()
{
  	output_b(0x0);					//Borra las salidas
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida

	  while(1)
 	{   while(input(PIN_A0));
	   	output_low(PIN_B2);		//Desactiva acstico A
		output_high(PIN_B3);    // Activar Bajada rpida BR
		
		while(input(PIN_A2));	// Espera se active sensor b
		output_low(PIN_B3);		// Desactiva bajada rpida BR
		output_high(PIN_B1);	// Activa el rel M
		output_high(PIN_B4);	// Activa bajada lenta BL

		while(input(PIN_A3));	//Espera llegar al final de carrera c
		output_low(PIN_B4);		//Dsactiva bajada lenta BL
		output_high(PIN_B0);	//Activa subida rpida SR
		
		while(input(PIN_A1));	//Espera retroceso hasta a
		output_low(PIN_B1);		//Desconecta el motor R
		output_low(PIN_B0);		//Desactiva subida rpida
		output_high(PIN_B2);	//Activa acstico A
	}	
}

